<?php 
session_start();
require_once("conexao.php");
$data_atual = date('Y-m-d');

// Verifica se a sessão já existe
if (!isset($_SESSION['sessao_carrinho'])) {
    // Gera um ID único com data, hora e valor randômico
    $data = date('YmdHis'); // Ex: 20250610141030
    $rand = rand(1000, 9999); // Número aleatório de 4 dígitos
    $_SESSION['sessao_carrinho'] = "CARRINHO_" . $data . "_" . $rand;
    
}

$sessao_carrinho = $_SESSION['sessao_carrinho'];

$url = @$_GET['url'];


$query = $pdo->query("SELECT * FROM produtos where url = '$url'");
$res = $query->fetchAll(PDO::FETCH_ASSOC);
if(@count($res) > 0){
  $id_empresa = @$res[0]['empresa'];
  $empresa = @$res[0]['empresa'];
  $codigo = $res[0]['codigo'];
  $nome = $res[0]['nome'];
  $categoria = $res[0]['categoria'];
  $sub_categoria = $res[0]['sub_categoria'];
  $valor_venda = $res[0]['valor_venda'];
  $valor_compra = $res[0]['valor_compra'];
  $estoque = $res[0]['estoque'];
  $nivel_estoque = $res[0]['nivel_estoque'];
  $foto = $res[0]['foto'];
  $ativo = $res[0]['ativo'];
  $descricao = $res[0]['descricao'];
  $valor_lucro = $res[0]['valor_lucro'];
  $lucro_reais = $res[0]['lucro_reais'];
  $valor_promo = $res[0]['valor_promocional'];
  $tem_estoque = $res[0]['tem_estoque'];
  $url = $res[0]['url'];
  $descricao_menor = $res[0]['descricao_menor'];
  $id_produto = $res[0]['id'];
}else{
  echo 'Url do Produto não Definida!';
  exit();
}


$valor_do_produto = $valor_venda;
if($valor_promo > 0){
  $valor_do_produto = $valor_promo;
}

$mostrar_site = $res[0]['mostrar_site'];
$descricao = $res[0]['descricao'];

$valor_vendaF = @number_format($valor_venda, 2, ',', '.');
$valor_compraF = @number_format($valor_compra, 2, ',', '.');
$lucro_reaisF = @number_format($lucro_reais, 2, ',', '.');
$valor_promoF = @number_format($valor_promo, 2, ',', '.');
$valor_do_produtoF = @number_format($valor_do_produto, 2, ',', '.');


$nomeF = @rawurlencode($nome);
$descricaoF = rawurlencode($descricao);
$descricao_menorF = rawurlencode($descricao_menor);

require_once("painel/buscar_config.php");

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8" />
<title><?php echo $nome ?> | Finalize sua Compra com Segurança</title>
<meta name="viewport" content="width=device-width, initial-scale=1" />
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://unpkg.com/lottie-web@5.7.4/build/player/lottie.min.js"></script>
<link rel="stylesheet" href="assets/css/estilo_produtos.css" />
<link rel="icon" href="<?php echo $url_sistema ?>img/<?php echo $icone_sistema ?>" type="image/x-icon" />

<meta name="keywords" content="checkout marketing, compra produto digital, link de vendas, gestor de campanhas, sistema marketing online, saas de vendas, automação de marketing" />

<meta name="description" content="<?php echo $descricao_menor ?>" />

<meta property="og:title" content="<?php echo $nome ?>" />
<meta property="og:description" content="<?php echo $descricao_menor ?>" />
<meta property="og:image" content="<?php echo $url_sistema ?>painel/images/<?php echo $foto ?>" />
<meta property="og:url" content="<?php echo $url_pagina ?>" />
<meta property="og:type" content="product" />

<!-- Twitter Cards -->
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="<?php echo $nome ?>" />
<meta name="twitter:description" content="<?php echo $descricao_menor ?>" />
<meta name="twitter:image" content="<?php echo $url_sistema ?>img/<?php echo $logo_sistema ?>" />

<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<link rel="preconnect" href="https://cdn.tailwindcss.com">

<script src="https://unpkg.com/lottie-web@5.7.4/build/player/lottie.min.js" defer></script>


</head>
<body class="bg-gray-100 py-6 px-3 sm:px-6">

<div class="max-w-lg sm:max-w-xl md:max-w-2xl mx-auto bg-white rounded-2xl shadow-xl p-5 sm:p-8">
<!-- Cabeçalho -->
<div class="flex flex-col sm:flex-row items-center justify-between mb-5 gap-4 sm:gap-0">
<img src="img/<?php echo $logo_sistema ?>" alt="Logo" class="w-24 sm:w-28" />
<span class="flex items-center gap-1 text-sm sm:text-base text-green-600 font-semibold">
<div id="iconSeguranca" class="w-6 h-6"></div>
Compra 100% Segura
</span>
</div>

<!-- Barra de progresso -->
<div class="h-2 w-full bg-gray-200 rounded-full mb-6">
<div class="h-2 bg-lime-400 rounded-full w-2/3"></div>
</div>

<!-- Produto principal -->
<div class="flex flex-row items-center mb-6 gap-4">
  <img src="painel/images/produtos/<?php echo $foto ?>" class="w-24 h-24 sm:w-28 sm:h-28 rounded-lg object-cover" alt="<?php echo $nome ?>" />
  
  <div class="flex-1 min-w-0">
    <h2 class="text-base sm:text-lg font-bold text-gray-800 truncate"><?php echo $nome ?></h2>
    <p class="text-gray-600 text-sm sm:text-base mb-2 line-clamp-2"><?php echo $descricao_menor ?></p>
    <span id="precoProduto" class="text-lg sm:text-xl font-bold text-green-700 block">R$ <?php echo $valor_do_produtoF ?></span>
  </div>
</div>



<div class="mb-4 text-center">
  <!-- Botão estilizado e centralizado -->
  <button 
    onclick="document.getElementById('descricaoBox').classList.toggle('hidden')" 
    class="inline-flex items-center gap-2 text-sm px-5 py-2 bg-lime-100 text-lime-700 font-medium rounded-full hover:bg-lime-200 transition"
  >
    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
    </svg>
    Ver descrição completa do produto
  </button>

  <!-- Área da descrição -->
  <div id="descricaoBox" class="hidden mt-3 mx-auto max-w-xl bg-gray-50 border border-gray-300 rounded p-4 text-sm text-gray-700 text-left">
    <?php echo nl2br($descricao) ?>
  </div>
</div>



<!-- Cupom de desconto -->
<div class="flex flex-col sm:flex-row items-center gap-3 mb-5">
<div id="iconCupom" class="w-6 h-6"></div>
<input
  type="text"
  placeholder="Digite seu cupom"
  class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring focus:ring-lime-400"
  id="cupom"
/>

<button
class="bg-lime-400 px-5 py-2 rounded font-bold text-black hover:bg-lime-500 transition w-full sm:w-auto"
onclick="cupom()"
type="button"
>
Aplicar
</button>
</div>
<div id="cupomFeedback" class="text-sm mb-5"></div>


<?php 
  $query = $pdo->query("SELECT * from produtos_relacionados where produto = '$id_produto' order by id asc");
  $res = $query->fetchAll(PDO::FETCH_ASSOC);
$linhas = @count($res);
if ($linhas > 0) {
 ?>

<!-- Produtos Relacionados -->
<div class="bg-gray-50 rounded-xl p-5 mb-6 border border-lime-200 max-w-xl mx-auto">
<div class="font-semibold text-gray-700 mb-3 text-sm sm:text-base">Leve junto e ganhe desconto:</div>
<div class="text-lime-700 text-xs sm:text-sm font-semibold mb-4 flex items-center gap-1">
<svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 sm:w-5 sm:h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m2 0a8 8 0 11-16 0 8 8 0 0116 0z" />
</svg>
Só para quem compra agora! Aproveite esta oferta exclusiva do checkout.
</div>

<?php 
for ($i = 0; $i < $linhas; $i++) {
    $id_rel = $res[$i]['id'];
    $produto_rel = $res[$i]['produto_rel'];


$query5 = $pdo->query("SELECT * FROM produtos where id = '$produto_rel'");
$res5 = $query5->fetchAll(PDO::FETCH_ASSOC);
$nome_rel = $res5[0]['nome'];
$valor_venda_rel = $res5[0]['valor_venda'];
$foto_rel = $res5[0]['foto'];
$descricao_rel = $res5[0]['descricao'];
$valor_promo_rel = $res5[0]['valor_promocional'];
$url_rel = $res5[0]['url'];
$descricao_menor_rel = $res5[0]['descricao_menor'];
$id_produto_rel = $res5[0]['id'];

$valor_do_produto_rel = $valor_venda_rel;
$ocultar_promo = 'none';
$porcentagem_desconto = 0; // valor padrão caso não tenha promoção

if ($valor_promo_rel > 0) {
    $ocultar_promo = '';
    $valor_do_produto_rel = $valor_promo_rel;

    // Calcula a porcentagem de desconto
    if ($valor_venda_rel > 0 && $valor_venda_rel > $valor_promo_rel) {
        $desconto = (($valor_venda_rel - $valor_promo_rel) / $valor_venda_rel) * 100;
        $porcentagem_desconto = round($desconto);
    }
}


$valor_venda_relF = @number_format($valor_venda_rel, 2, ',', '.');
$valor_promo_relF = @number_format($valor_promo_rel, 2, ',', '.');
$valor_do_produto_relF = @number_format($valor_do_produto_rel, 2, ',', '.');

$query5 = $pdo->query("SELECT * FROM venda_relacionados where produto = '$id_produto_rel' and sessao = '$sessao_carrinho'");
$res5 = $query5->fetchAll(PDO::FETCH_ASSOC);
if(@count($res5) > 0){
  $checkbox_marcado = 'checked';
}else{
  $checkbox_marcado = '';
}

 ?>


<div class="related-product flex items-start justify-between mb-4">
<a href="produto-<?php echo $url_rel ?>" title="Ir Para <?php echo $nome_rel ?>">
<img src="painel/images/produtos/<?php echo $foto_rel ?>" alt="<?php echo $nome_rel ?>" class="w-12 h-12 rounded-lg flex-shrink-0" />
<div class="related-product-info flex-1 ml-4 mr-4">
<h4 class="font-semibold text-base leading-tight"><?php echo $nome_rel ?></h4>
</a>
<p class="text-gray-600 text-sm mb-1"><?php echo $descricao_menor_rel ?></p>
<div class="flex items-center gap-2">
<span class="line-through text-gray-400 text-sm" style="display:<?php echo $ocultar_promo ?>">R$ <?php echo $valor_venda_relF ?></span>
<span class="text-green-700 font-bold text-lg">R$ <?php echo $valor_do_produto_rel ?></span>
<span class="bg-lime-100 text-lime-800 font-semibold rounded px-2 py-0.5 ml-1 text-xs" style="display:<?php echo $ocultar_promo ?>">-<?php echo $porcentagem_desconto ?>%</span>
</div>
</div>
<input
type="checkbox"
class="accent-lime-500 mt-2 w-5 h-5 flex-shrink-0 related-product-checkbox"
data-price="49"
id="checkbox_produto_<?php echo $id_produto_rel ?>"
onchange="atualizar(this, '<?php echo $id_produto_rel ?>', '<?php echo $valor_do_produto_rel ?>')"
<?php echo $checkbox_marcado ?>
/>
</div>
<?php } ?>

</div>

<?php } ?>

<!-- Dados do comprador -->
<form class="mb-6 grid gap-4 sm:grid-cols-2">

    <input type="text" placeholder="CPF" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="cpf" onblur="buscarDados()" required />

  <input type="text" placeholder="Nome completo" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="nome" required />
  
  <input type="email" placeholder="E-mail" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="email" required />
  
  <input type="tel" placeholder="Telefone" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="telefone" onkeyup="verificarTelefone('telefone', this.value);" required />

  <?php if($endereco_checkout != "Não"){ ?>
  
  <input type="text" placeholder="CEP" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="cep" required />
  
  <input type="text" placeholder="Rua" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="rua" required />
  
  <input type="text" placeholder="Número" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="numero" required />
  
  <input type="text" placeholder="Complemento" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="complemento" />
  
  <input type="text" placeholder="Bairro" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="bairro" required />
  
  <input type="text" placeholder="Cidade" class="border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full" id="cidade" required />
  
  <select id="estado" class="border border-gray-300 bg-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-lime-500 w-full text-gray-700" required>
    <option value="">Selecione o Estado</option>
    <option value="AC">Acre (AC)</option>
    <option value="AL">Alagoas (AL)</option>
    <option value="AP">Amapá (AP)</option>
    <option value="AM">Amazonas (AM)</option>
    <option value="BA">Bahia (BA)</option>
    <option value="CE">Ceará (CE)</option>
    <option value="DF">Distrito Federal (DF)</option>
    <option value="ES">Espírito Santo (ES)</option>
    <option value="GO">Goiás (GO)</option>
    <option value="MA">Maranhão (MA)</option>
    <option value="MT">Mato Grosso (MT)</option>
    <option value="MS">Mato Grosso do Sul (MS)</option>
    <option value="MG">Minas Gerais (MG)</option>
    <option value="PA">Pará (PA)</option>
    <option value="PB">Paraíba (PB)</option>
    <option value="PR">Paraná (PR)</option>
    <option value="PE">Pernambuco (PE)</option>
    <option value="PI">Piauí (PI)</option>
    <option value="RJ">Rio de Janeiro (RJ)</option>
    <option value="RN">Rio Grande do Norte (RN)</option>
    <option value="RS">Rio Grande do Sul (RS)</option>
    <option value="RO">Rondônia (RO)</option>
    <option value="RR">Roraima (RR)</option>
    <option value="SC">Santa Catarina (SC)</option>
    <option value="SP">São Paulo (SP)</option>
    <option value="SE">Sergipe (SE)</option>
    <option value="TO">Tocantins (TO)</option>
    <option value="EST">Estrangeiro</option>
  </select>

<?php } ?>
</form>




<!-- Resumo final -->
<div class="bg-lime-50 border border-lime-200 rounded-lg p-4 mb-6 max-w-md mx-auto sm:mx-0 flex flex-col items-center justify-center text-center">
<div class="font-bold text-gray-800 text-lg mb-1 w-full max-w-xs">
Total:
<span id="totalResumo" class="ml-2 font-extrabold"><span id="total_span"></span></span>
</div>
<div id="resumoDesconto" class="text-green-600 text-sm w-full max-w-xs">
<!-- Texto do desconto -->
</div>
</div>

<!-- Botão Finalizar Compra centralizado -->
<button
class="w-full max-w-md mx-auto block bg-lime-400 py-3 rounded-xl font-bold text-lg text-black hover:bg-lime-500 transition mb-6" onclick="pagamento()"
>
Ir para Pagamento
</button>

<!-- Garantia centralizada -->
<div
class="flex flex-col items-center text-gray-600 mt-4 text-sm sm:text-base max-w-md mx-auto text-center"
>
<div class="flex items-center gap-2 justify-center">
<div id="iconGarantia" class="w-7 h-7"></div>
Satisfação garantida ou seu dinheiro de volta
</div>
</div>
</div>


<input type="hidden" id="total_final">


</body>
</html>





<script src="painel/js/jquery-1.11.1.min.js"></script>
<script src="painel/js/alertas.js"></script>
<script src="painel/js/mascaras.js"></script>
<!-- Ajax para funcionar Mascaras JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.11/jquery.mask.min.js"></script>



<!-- SweetAlert CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

  <!-- SweetAlert JS -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Alertas -->
<script src="assets/plugins/sweet-alert/sweetalert.min.js"></script>
<script src="assets/plugins/sweet-alert/jquery.sweet-alert.js"></script>



<script type="text/javascript">
  $(document).ready(function () {
    totalizar();
  });
</script>



<script type="text/javascript">
  function cupom(){
        var codigo =  $('#cupom').val();
        var total_final =  '<?=$valor_do_produto?>';
        var id_empresa =  '<?=$id_empresa?>';

         $.ajax({
           url: 'ajax/cupom.php',
           method: 'POST',
           data: {codigo, total_final, id_empresa},
           dataType: "html",

           success:function(result){               
                if(result.trim() == 'Inserido'){
                  alertSucesso('Cupom Inserido!');
                    $('#cupom').val('');                    
                    totalizar();

                }else{
                    alertaInformativo(result)
                }
            }
        });
    }

    function totalizar(){
       var id_empresa =  '<?=$id_empresa?>';
       var valor_do_produto =  '<?=$valor_do_produto?>';

       $.ajax({
           url: 'ajax/totalizar.php',
           method: 'POST',
           data: {id_empresa, valor_do_produto},
           dataType: "html",

           success:function(result){                         
                $('#total_final').val(result);
               
               $('#total_span').text(
                  parseFloat(result).toLocaleString('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                  })
                );

            }
        });
    }


    function atualizar(checkbox, id, valor){
      
      if (checkbox.checked) {
        var marcado = 'Sim';    
         } else {
          var marcado = 'Não';  
        }

        $.ajax({
           url: 'ajax/produto_relacionado.php',
           method: 'POST',
           data: {id, marcado, valor},
           dataType: "html",

           success:function(result){                         
                if(result.trim() == 'Inserido'){                                   
                    totalizar();
                }else{
                    alertaInformativo(result)
                }
            }
        });
    
    }


    // FUNÇÃO PARA VERIFICAR TELEFONE
function verificarTelefone(tel, valor) {
    if (valor.length > 14) {
        $('#' + tel).mask('(00) 00000-0000');
    } else if (valor.length == 14) {
        $('#' + tel).mask('(00) 0000-00000');
    } else {
        $('#' + tel).mask('(00) 0000-0000');

    }

    document.getElementById(tel).setSelectionRange(100, 100);
}

function pagamento(){
  var valor_produto =  '<?=$valor_do_produto?>';
  var id_empresa =  '<?=$id_empresa?>';
  var id_produto =  '<?=$id_produto?>';
  var endereco_checkout =  '<?=$endereco_checkout?>';

  var nome =  $('#nome').val();
  var email =  $('#email').val();
  var cpf =  $('#cpf').val();
  var telefone =  $('#telefone').val();

  var cep = $('#cep').val();
  var rua = $('#rua').val();
  var numero = $('#numero').val();
  var complemento = $('#complemento').val();
  var bairro = $('#bairro').val();
  var cidade = $('#cidade').val();
  var estado = $('#estado').val();
  

  if(nome == ""){
    alertaInformativo("Preencha o Nome!");
    return;
  }

  if(email == ""){
    alertaInformativo("Preencha o Email!");
    return;
  }

  if(cpf == ""){
    alertaInformativo("Preencha o CPF!");
    return;
  }

  if(telefone == ""){
    alertaInformativo("Preencha o Telefone!");
    return;
  }

  if(endereco_checkout != "Não"){
      if(cep == ""){
        alertaInformativo("Preencha o CEP!");
        return;
      }

      if (rua == "") {
        alertaInformativo("Preencha a Rua!");
        return;
      }
      if (numero == "") {
        alertaInformativo("Preencha o Número!");
        return;
      }
      if (bairro == "") {
        alertaInformativo("Preencha o Bairro!");
        return;
      }
      if (cidade == "") {
        alertaInformativo("Preencha a Cidade!");
        return;
      }
      if (estado == "") {
        alertaInformativo("Selecione o Estado!");
        return;
      }
  }

  $.ajax({
           url: 'ajax/checkout.php',
           method: 'POST',
           data: {valor_produto, id_empresa, nome, email, cpf, telefone, id_produto, cep, rua, numero, complemento, bairro, cidade, estado},
           dataType: "html",

           success:function(resultado){       
                var split = resultado.split('*');
                var result = split[0];
                var id = split[1];
                if(result.trim() == 'Finalizado'){                                                 
                    window.open("pagar/" + id, "_blank");
                }else{
                    alertaInformativo(result)
                }
            }
        });

}
</script>



<script>
  document.getElementById('cep').addEventListener('blur', function () {
    const cep = this.value.replace(/\D/g, '');

    if (cep.length !== 8) {
      alertaInformativo('CEP inválido!');
      return;
    }

    fetch(`https://viacep.com.br/ws/${cep}/json/`)
      .then(response => response.json())
      .then(data => {
        if (data.erro) {
          alertaInformativo('CEP não encontrado!');
          return;
        }

        // Preenche os campos com os dados da API
        document.getElementById('rua').value = data.logradouro || '';
        document.getElementById('bairro').value = data.bairro || '';
        document.getElementById('cidade').value = data.localidade || '';
        document.getElementById('estado').value = data.uf || '';
      })
      .catch(error => {
        console.error('Erro ao buscar o CEP:', error);
        alertaInformativo('Erro ao buscar o CEP. Tente novamente.');
      });
  });
</script>



<script type="text/javascript">
  function buscarDados(){    
    var cpf =  $('#cpf').val();
    var id_empresa =  '<?=$id_empresa?>';

    $.ajax({
           url: 'ajax/buscar_dados.php',
           method: 'POST',
           data: {cpf, id_empresa},
           dataType: "html",

           success:function(result){ 
                if(result.trim() != "") {
                  let dados = result.split('*');
                // Atribui os valores aos inputs correspondentes
                $('#nome').val(dados[0]);
                $('#telefone').val(dados[1]);
                $('#email').val(dados[2]);
                $('#rua').val(dados[3]);
                //$('#cpf').val(dados[4]);
                $('#numero').val(dados[5]);
                $('#bairro').val(dados[6]);
                $('#cidade').val(dados[7]);
                $('#estado').val(dados[8]);
                $('#cep').val(dados[9]);
                $('#complemento').val(dados[10]);
                }                       
                
            }
        });
    
  }
</script>